-- new script file
function OnAfterSceneLoaded(self)
  CreateTriggerSources(self)
end

function OnThink(self)
  if not self.initialized then
    self.initialized = true
    
    if not self.loaded then
      self.counted = false 
    end  
    
    self.initCount:LinkToTarget("unitInit")
    self.killCount:LinkToTarget("unitKill")
  end
  
  if not self.counted then
    self.counted = true
    self.initCount:TriggerAllTargets()
  end
end

function OnBeforeDeath(self)
  self.killCount:TriggerAllTargets()
end

function OnSerialize(self, ar)
    if (ar:IsLoading()) and Citadels.GetLoadGameRunning() then
    CreateTriggerSources(self)
    self.loaded = true
    self.counted = ar:Read()
  elseif (ar:IsSaving()) then
    ar:Write(self.counted)
  end  
end

function CreateTriggerSources(self)
  self:AddTriggerSource("initCount")
  self:AddTriggerSource("killCount")
end
